#include "Bonus.h"

bool Bonus::firstInit = true;
Texture *Bonus::healthTex = NULL;
Texture *Bonus::ammoTex = NULL;

Bonus :: Bonus() {

   if (Bonus::firstInit) {
      Bonus::firstInit = false;

      // init textures here
      Bonus::healthTex = new Texture("data/health_bonus.png");
      Bonus::ammoTex = new Texture("data/ammo_bonus.png");
      Bonus::healthTex->build();
      Bonus::ammoTex->build();

   }

   setType(BT_HEALTH);
   setPos(0,0);

   jumping = false;
   jumpTime = 0;

}

Bonus :: ~Bonus() {
}

void Bonus :: update(float dt) {
   if (jumping) {
      y += dt * jumpForce;
      jumpForce -= dt * 10.0f;      
   }

   jumpTime += dt;
   if (jumpTime > AUTO_JUMP_TIME) {
      beginJump(2.0f);
      jumpTime = 0;
   }

}

void Bonus :: render() {

   glPushMatrix();

   Texture *t;
   if (type == BT_HEALTH)
      t = healthTex;
   else
   if (type == BT_AMMO)
      t = ammoTex;

   const float sx = 0.2f;
   const float sy = 0.2f;
   
   glColor3f(1,1,1);
   glDisable(GL_BLEND);

   glTranslatef(x,y,0);

   t->begin();
   glBegin(GL_QUADS);
   glTexCoord2f(0,0); glVertex2f(-sx,-sy);
   glTexCoord2f(1,0); glVertex2f( sx,-sy);
   glTexCoord2f(1,1); glVertex2f( sx, sy);
   glTexCoord2f(0,1); glVertex2f(-sx, sy);
   glEnd();
   t->end();

   glPopMatrix();

}